<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProcessExecution extends Model 
{

    protected $table = 'process_execution';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'process_id', 'process_version', 'process_steps_version', 'start_date', 'end_date', 'deadline_date');

    public function user()
    {
        return $this->belongsTo('App\Models\User');
    }

    public function process()
    {
        return $this->belongsTo('App\Models\Process');
    }

    public function steps()
    {
        return $this->hasMany('App\Models\ProcessExecutionStep');
    }

}